
////////////////////////////////////////////////////////////////////////////
//                                                                        //
//            File: Isc.h                                                 //
//            started on: 5/2/92                                          //
//                                                                        //
////////////////////////////////////////////////////////////////////////////
//                                                                        //
//                              V3.66                                     //
//                            ---------                                   //
//                                                                        //
////////////////////////////////////////////////////////////////////////////
//                                                                        //
//  - DO not use the TINY memory model.                                   //
//                                                                        //
////////////////////////////////////////////////////////////////////////////
//                                                                        //
// new in V3.0:- the dispatch method has been moved to mostly C code.     //
//                                                                        //
// new in V3.5:- the assembler part has been optimized significantly.     //
//      + An example of stack frame management has been added.            //
//                                                                        //
// new in V3.6:- the stack frame has been integrated into ISC itself.     //
//      + the way of calculating how much space the program takes has been//
//        updated to ensure that no heap blocks may be forgotten (that    //
//        may of happened in the V3.5-- method!).                         //
//                                                                        //
// new in V3.66:- Interrupt handlers that are not TSRs (like in embedded  //
//      + systems) can use #define __NOT_TSR__ to make lib smaller- and   //
//        more compatible. Assume DS/SS problem solved. But DO NOT USE    //
//        ASSUME ALWAYS IN MEDIUM- LARGE models (might be a problem!).    //
//                                                                        //
////////////////////////////////////////////////////////////////////////////
//                                                                        //
//                    by Ofer Laor (AKA LeucroTTA)                        //
//                                                                        //
////////////////////////////////////////////////////////////////////////////

#ifndef __ISC_H
#define __ISC_H

#if (__BORLANDC__< 0x300)
#error Fatal: ISC will only work on BC++ versions 3.0 and up!!!
#endif


#pragma option -k    // standard stack frame from now on...

#include <stddef.h>; // NULL, size_t.

struct IBYTEREGS  {
  unsigned char  al, ah, bl, bh,
                 cl, ch, dl, dh;
};

struct IWORDREGS  {
  unsigned int  ax, bx, cx, dx,
                si, di, ds, es, cs, flags, ip, bp;
};


union IREGS {
      struct IWORDREGS x;
      struct IBYTEREGS h;
};


extern "C" void interrupt ISCDispatch(unsigned bp, unsigned di, unsigned si,
                           unsigned ds, unsigned es, unsigned dx,
                           unsigned cx, unsigned bx, unsigned ax,
                           unsigned ip, unsigned cs, unsigned flags
);

class ISC {
protected:

       virtual void isr (IREGS &regs);
       virtual void isr (void);

       char* NewServerPtr;
       unsigned char InitFlag;
       int interrupt_num;
       void interrupt (*old_vect)(...);

       friend void interrupt ISCDispatch(unsigned bp, unsigned di, unsigned si,
                           unsigned ds, unsigned es, unsigned dx,
                           unsigned cx, unsigned bx, unsigned ax,
                           unsigned ip, unsigned cs, unsigned flags);
       virtual void far * GetLocalRoutine(void);

       static char *StackFrame;
       static unsigned long StackFrameLen;
       static int ISCcount;

       ISC (void);
       virtual ~ISC (void);
public:
       void activate(const int int_num); // call this function if you want to
                                         // hook an interrupt, and you didn't
                                         // do it through the constructor.
       void deactivate(void); // call this function to unhook the interrupt.

#ifndef __NOT_TSR__
       static int TSR(const int exit_code= 0, const unsigned long extraheaplen= 0);
                                         // call this function to remain TSR,
                                         // exit code ususaly is 0 (unless
                                         // you change it), extraheaplen is
                                         // the amount of heap you want to
                                         // remain on top of what's already
                                         // allocated... (makes the TSR
                                         // longer in that many bytes...).

       static int is_TSR(const char* app_name);
                                         // checks to see if this program is
                                         // already resident.
                                         // it checks for another TSR that
                                         // called the is_TSR with the same
                                         // app_name...
#endif
       static int reallocStack(unsigned StackLen);
                                         // reallocates the stack frame.
                                         // HAS to be called BEFORE any ISC
                                         // is active!!!

};


#endif /* __ISC_H */
